<?php
require 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $room_id = (int)($_POST['room_id'] ?? 0);
    $room    = $_POST['room'] ?? '';

    if ($room_id > 0 && $room !== '') {
        $stmt = $mysqli->prepare(
            "UPDATE classroom SET room = ? WHERE room_id = ?"
        );
        $stmt->bind_param("si", $room, $room_id);
        $stmt->execute();
        $stmt->close();
    }
}

$result = get_all("SELECT * FROM classroom ORDER BY room_id");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Classrooms</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<h1>Classrooms</h1>
<p>Viewed at: <?php echo date('Y-m-d H:i:s'); ?></p>

<p>
    <a href="class_standing.php">Class Standing</a> |
    <a href="students.php">Students</a> |
    <a href="instructors.php">Instructors</a> |
    <a href="classrooms.php">Classrooms</a> |
    <a href="courses.php">Courses</a> |
    <a href="enrolled.php">Enrolled</a>
</p>

<h2>Update Room Number</h2>
<form method="post">
    Room ID: <input type="number" name="room_id" required>
    New Room: <input type="text" name="room" required>
    <input type="submit" value="Update">
</form>

<h2>Classroom List</h2>
<table>
<tr>
    <th>ID</th><th>Building</th><th>Floor</th><th>Room</th>
</tr>
<?php while ($row = $result->fetch_assoc()) : ?>
<tr>
    <td><?php echo $row['room_id']; ?></td>
    <td><?php echo htmlspecialchars($row['building']); ?></td>
    <td><?php echo $row['floor']; ?></td>
    <td><?php echo htmlspecialchars($row['room']); ?></td>
</tr>
<?php endwhile; ?>
</table>
</body>
</html>
