<?php
require 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $crn  = (int)($_POST['crn'] ?? 0);
    $days = $_POST['days'] ?? '';
    $time = $_POST['time'] ?? '';

    if ($crn > 0 && $days !== '' && $time !== '') {
        $stmt = $mysqli->prepare(
            "UPDATE course SET days = ?, time = ? WHERE crn = ?"
        );
        $stmt->bind_param("ssi", $days, $time, $crn);
        $stmt->execute();
        $stmt->close();
    }
}

$result = get_all("SELECT * FROM course ORDER BY crn");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Courses</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<h1>Courses</h1>
<p>Viewed at: <?php echo date('Y-m-d H:i:s'); ?></p>

<p>
    <a href="class_standing.php">Class Standing</a> |
    <a href="students.php">Students</a> |
    <a href="instructors.php">Instructors</a> |
    <a href="classrooms.php">Classrooms</a> |
    <a href="courses.php">Courses</a> |
    <a href="enrolled.php">Enrolled</a>
</p>

<h2>Update Days and Time</h2>
<form method="post">
    CRN: <input type="number" name="crn" required>
    Days: <input type="text" name="days" required>
    Time: <input type="text" name="time" required>
    <input type="submit" value="Update">
</form>

<h2>Course List</h2>
<table>
<tr>
    <th>CRN</th><th>Instructor ID</th><th>Classroom ID</th><th>Days</th><th>Time</th>
</tr>
<?php while ($row = $result->fetch_assoc()) : ?>
<tr>
    <td><?php echo $row['crn']; ?></td>
    <td><?php echo $row['instructor_id']; ?></td>
    <td><?php echo $row['classroom_id']; ?></td>
    <td><?php echo htmlspecialchars($row['days']); ?></td>
    <td><?php echo htmlspecialchars($row['time']); ?></td>
</tr>
<?php endwhile; ?>
</table>
</body>
</html>
