<?php
require 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $first = $_POST['first_name'] ?? '';
    $last  = $_POST['last_name'] ?? '';
    $spec  = $_POST['specialty'] ?? '';

    if ($first !== '' && $last !== '') {
        $stmt = $mysqli->prepare(
            "INSERT INTO instructor (first_name, last_name, specialty)
             VALUES (?, ?, ?)"
        );
        $stmt->bind_param("sss", $first, $last, $spec);
        $stmt->execute();
        $stmt->close();
    }
}

$result = get_all("SELECT * FROM instructor ORDER BY employee_id");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Instructors</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<h1>Instructors</h1>
<p>Viewed at: <?php echo date('Y-m-d H:i:s'); ?></p>

<p>
    <a href="class_standing.php">Class Standing</a> |
    <a href="students.php">Students</a> |
    <a href="instructors.php">Instructors</a> |
    <a href="classrooms.php">Classrooms</a> |
    <a href="courses.php">Courses</a> |
    <a href="enrolled.php">Enrolled</a>
</p>

<h2>Add Instructor</h2>
<form method="post">
    First: <input type="text" name="first_name" required>
    Last: <input type="text" name="last_name" required>
    Specialty: <input type="text" name="specialty">
    <input type="submit" value="Add">
</form>

<h2>Instructor List</h2>
<table>
<tr>
    <th>ID</th><th>First</th><th>Last</th><th>Specialty</th>
</tr>
<?php while ($row = $result->fetch_assoc()) : ?>
<tr>
    <td><?php echo $row['employee_id']; ?></td>
    <td><?php echo htmlspecialchars($row['first_name']); ?></td>
    <td><?php echo htmlspecialchars($row['last_name']); ?></td>
    <td><?php echo htmlspecialchars($row['specialty']); ?></td>
</tr>
<?php endwhile; ?>
</table>
</body>
</html>
