CREATE DATABASE IF NOT EXISTS school;
USE school;

CREATE TABLE IF NOT EXISTS class_standing (
  id INT PRIMARY KEY,
  class VARCHAR(20) NOT NULL,
  max_credits INT NOT NULL,
  min_credits INT NOT NULL
);

INSERT INTO class_standing (id, class, max_credits, min_credits) VALUES
(1,'Freshman',17,0),
(2,'Sophomore',18,30),
(3,'Junior',18,60),
(4,'Senior',18,90);

CREATE TABLE IF NOT EXISTS student (
  student_id INT AUTO_INCREMENT PRIMARY KEY,
  first_name VARCHAR(50) NOT NULL,
  last_name VARCHAR(50) NOT NULL,
  street VARCHAR(100),
  city VARCHAR(50),
  state CHAR(2),
  zip VARCHAR(10),
  class_standing INT,
  major VARCHAR(50),
  CONSTRAINT fk_student_class
    FOREIGN KEY (class_standing) REFERENCES class_standing(id)
);

INSERT INTO student
(first_name,last_name,street,city,state,zip,class_standing,major) VALUES
('Alex','Brown','1 Main St','Town','ST','11111',1,'CS'),
('Jamie','Lopez','2 Main St','Town','ST','11111',1,'Math'),
('Chris','Kim','3 Main St','Town','ST','11111',2,'CS'),
('Taylor','Ng','4 Main St','Town','ST','11111',2,'Biology'),
('Jordan','Lee','5 Main St','Town','ST','11111',2,'Chemistry'),
('Pat','Morris','6 Main St','Town','ST','11111',3,'CS'),
('Sam','Young','7 Main St','Town','ST','11111',3,'English'),
('Riley','Hall','8 Main St','Town','ST','11111',3,'History'),
('Morgan','Price','9 Main St','Town','ST','11111',4,'CS'),
('Casey','Wong','10 Main St','Town','ST','11111',4,'Math');

CREATE TABLE IF NOT EXISTS instructor (
  employee_id INT AUTO_INCREMENT PRIMARY KEY,
  first_name VARCHAR(50) NOT NULL,
  last_name VARCHAR(50) NOT NULL,
  specialty VARCHAR(50)
);

INSERT INTO instructor (first_name,last_name,specialty) VALUES
('Dana','Scott','Computer Science'),
('Lee','Adams','Mathematics'),
('Mia','Reed','Biology');

CREATE TABLE IF NOT EXISTS classroom (
  room_id INT AUTO_INCREMENT PRIMARY KEY,
  building VARCHAR(50) UNIQUE,
  floor INT NOT NULL DEFAULT 1,
  room VARCHAR(10)
);

INSERT INTO classroom (building,floor,room) VALUES
('Science',1,'101'),
('Technology',2,'201'),
('Math',3,'301');

CREATE TABLE IF NOT EXISTS course (
  crn INT PRIMARY KEY,
  instructor_id INT,
  classroom_id INT,
  days VARCHAR(20),
  time VARCHAR(20),
  CONSTRAINT fk_course_instructor
    FOREIGN KEY (instructor_id) REFERENCES instructor(employee_id),
  CONSTRAINT fk_course_classroom
    FOREIGN KEY (classroom_id) REFERENCES classroom(room_id)
);

INSERT INTO course (crn,instructor_id,classroom_id,days,time) VALUES
(1001,1,1,'MWF','09:00'),
(1002,2,2,'TR','11:00'),
(1003,3,3,'MW','14:00');

CREATE TABLE IF NOT EXISTS enrolled (
  student_id INT,
  course_crn INT,
  PRIMARY KEY (student_id, course_crn),
  CONSTRAINT fk_enrolled_student
    FOREIGN KEY (student_id) REFERENCES student(student_id),
  CONSTRAINT fk_enrolled_course
    FOREIGN KEY (course_crn) REFERENCES course(crn)
);

INSERT INTO enrolled (student_id,course_crn) VALUES
(1,1001),
(2,1001),
(3,1002),
(4,1002),
(5,1003),
(6,1003);

SELECT * FROM class_standing;
SELECT * FROM student;
SELECT * FROM instructor;
SELECT * FROM classroom;
SELECT * FROM course;
SELECT * FROM enrolled;
