<?php
require 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $first = $_POST['first_name'] ?? '';
    $last  = $_POST['last_name'] ?? '';
    $class = (int)($_POST['class_standing'] ?? 1);
    $major = $_POST['major'] ?? '';

    if ($first !== '' && $last !== '') {
        $stmt = $mysqli->prepare(
            "INSERT INTO student (first_name, last_name, class_standing, major)
             VALUES (?, ?, ?, ?)"
        );
        $stmt->bind_param("ssis", $first, $last, $class, $major);
        $stmt->execute();
        $stmt->close();
    }
}

$result = get_all("SELECT * FROM student ORDER BY student_id");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Students</title>
    <link rel="stylesheet" href="style.css">
    <script>
    function confirmAdd() {
        return confirm("Add this student?");
    }
    </script>
</head>
<body>
<h1>Students</h1>
<p>Viewed at: <?php echo date('Y-m-d H:i:s'); ?></p>

<p>
    <a href="class_standing.php">Class Standing</a> |
    <a href="students.php">Students</a> |
    <a href="instructors.php">Instructors</a> |
    <a href="classrooms.php">Classrooms</a> |
    <a href="courses.php">Courses</a> |
    <a href="enrolled.php">Enrolled</a>
</p>

<h2>Add Student</h2>
<form method="post" onsubmit="return confirmAdd();">
    First: <input type="text" name="first_name" required>
    Last: <input type="text" name="last_name" required>
    Class Standing ID: <input type="number" name="class_standing" value="1">
    Major: <input type="text" name="major">
    <input type="submit" value="Add">
</form>

<h2>Student List</h2>
<table>
<tr>
    <th>ID</th><th>First</th><th>Last</th><th>Class ID</th><th>Major</th>
</tr>
<?php while ($row = $result->fetch_assoc()) : ?>
<tr>
    <td><?php echo $row['student_id']; ?></td>
    <td><?php echo htmlspecialchars($row['first_name']); ?></td>
    <td><?php echo htmlspecialchars($row['last_name']); ?></td>
    <td><?php echo $row['class_standing']; ?></td>
    <td><?php echo htmlspecialchars($row['major']); ?></td>
</tr>
<?php endwhile; ?>
</table>
</body>
</html>
