<?php
if (session_status()===PHP_SESSION_NONE){session_start();}
if(empty($_SESSION['uid'])){header("Location: login.php");exit;}
$err=""; $ok="";
$conn = new mysqli('localhost', 'mrussell_m1', 'Keon0716!', 'mrussell_midterm2');
$rooms=[]; $r=$conn->query("SELECT id,name FROM rooms ORDER BY name"); if($r){while($row=$r->fetch_assoc()){$rooms[]=$row;}}

if($_SERVER['REQUEST_METHOD']==='POST'){
  $room_id=(int)($_POST['room_id']??0); $date=trim($_POST['date']??''); $start=trim($_POST['start']??''); $end=trim($_POST['end']??'');
  if($room_id<=0 || $date==='' || $start==='' || $end==='') $err="Fill all fields.";
  if($err===""){
    try{$startDT=new DateTime($date.' '.$start); $endDT=new DateTime($date.' '.$end);}catch(Exception $e){$err="Invalid date/time.";}
  }
  if($err===""){
    if($endDT <= $startDT) $err="End time must be after start time.";
    if($startDT->format('Y-m-d')!==$endDT->format('Y-m-d')) $err="Reservation must be on the same day.";
    $dow=(int)$startDT->format('N'); if($dow>=6) $err="Weekends not allowed.";
    $sH=(int)$startDT->format('G'); $eH=(int)$endDT->format('G');
    $endBoundary=clone $endDT; $endBoundary->setTime(17,0,0);
    if($sH<9 || $eH>17 || $endDT>$endBoundary) $err="Business hours are 09:00–17:00.";
  }
  if($err===""){
    $s=$conn->real_escape_string($startDT->format('Y-m-d H:i:s')); $e=$conn->real_escape_string($endDT->format('Y-m-d H:i:s'));
    $q=$conn->query("SELECT COUNT(*) AS c FROM reservations WHERE room_id=$room_id AND start_time<'$e' AND end_time>'$s'");
    $c=$q?(int)$q->fetch_assoc()['c']:0; if($c>0)$err="Overlaps another reservation.";
  }
  if($err===""){
    $uid=(int)$_SESSION['uid'];
    $conn->query("INSERT INTO reservations (user_id,room_id,start_time,end_time) VALUES ($uid,$room_id,'$s','$e')");
    if($conn->affected_rows>0)$ok="Reservation saved."; else $err="Could not save.";
  }
}
?>
<!DOCTYPE html>
<html><head><meta charset="utf-8"><title>Reserve</title></head>
<body>
  <h2>Make a Reservation</h2>
  <?php if($err)echo"<p style='color:red'>".htmlspecialchars($err)."</p>"; ?>
  <?php if($ok)echo"<p style='color:green'>".htmlspecialchars($ok)."</p>"; ?>
  <form method="post">
    <p>Room:<br>
      <select name="room_id" required>
        <option value="">-- Select --</option>
        <?php foreach($rooms as $rm){ ?>
          <option value="<?php echo (int)$rm['id']; ?>"><?php echo htmlspecialchars($rm['name']); ?></option>
        <?php } ?>
      </select>
    </p>
    <p>Date:<br><input type="date" name="date" required></p>
    <p>Start Time:<br><input type="time" name="start" required></p>
    <p>End Time:<br><input type="time" name="end" required></p>
    <p><button>Reserve</button></p>
  </form>
  <p><a href="reservations.php?view=future">View Reservations</a></p>
</body></html>