<?php
require_once('database.php');

$category_name = filter_input(INPUT_POST, 'category_name');

if ($category_name === null || $category_name === false || trim($category_name) === '') {
    // If invalid, just go back to the category list (or you could show error.php if your app uses it)
    header("Location: category_list.php");
    exit();
}

$query = 'INSERT INTO categories (categoryName)
          VALUES (:category_name)';
$statement = $db->prepare($query);
$statement->bindValue(':category_name', trim($category_name));
$statement->execute();
$statement->closeCursor();

header("Location: category_list.php");
exit();
