<?php
require_once('database.php');

// Get the product id and category id from the POST
$product_id  = filter_input(INPUT_POST, 'product_id', FILTER_VALIDATE_INT);
$category_id = filter_input(INPUT_POST, 'category_id', FILTER_VALIDATE_INT);

// These will be filled either from POST (after submit) or from DB (first load)
$product_code = filter_input(INPUT_POST, 'product_code');
$product_name = filter_input(INPUT_POST, 'product_name');
$list_price   = filter_input(INPUT_POST, 'list_price', FILTER_VALIDATE_FLOAT);

// If we DON'T have product_code, this is the first time we came here
// from the Product List "Edit" button -> load product from DB.
if ($product_code == NULL || $product_name == NULL || $list_price == NULL) {

    // Get the product row for this product_id
    $query = 'SELECT * FROM products
              WHERE productID = :product_id';
    $statement = $db->prepare($query);
    $statement->bindValue(':product_id', $product_id);
    $statement->execute();
    $product = $statement->fetch();
    $statement->closeCursor();

    // Set variables for the form
    $category_id  = $product['categoryID'];
    $product_code = $product['productCode'];
    $product_name = $product['productName'];
    $list_price   = $product['listPrice'];

} else {
    // We DO have product_code/name/price -> user clicked "Update Product"
    // Do the UPDATE and go back to Product List

    $query = 'UPDATE products
              SET categoryID = :category_id,
                  productCode = :product_code,
                  productName = :product_name,
                  listPrice = :list_price
              WHERE productID = :product_id';
    $statement = $db->prepare($query);
    $statement->bindValue(':category_id',  $category_id);
    $statement->bindValue(':product_code', $product_code);
    $statement->bindValue(':product_name', $product_name);
    $statement->bindValue(':list_price',   $list_price);
    $statement->bindValue(':product_id',   $product_id);
    $statement->execute();
    $statement->closeCursor();

    // Redirect back to the product list for this category
    $query = NULL;
    header("Location: .?category_id=" . $category_id);
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Edit Product</title>
    <link rel="stylesheet" type="text/css" href="main.css" />
</head>
<body>
<header><h1>Product Manager</h1></header>
<main>
    <h1>Edit Product</h1>

    <form action="edit_product.php" method="post">
        <!-- keep ids so we know what to update -->
        <input type="hidden" name="product_id"  value="<?php echo $product_id; ?>">
        <input type="hidden" name="category_id" value="<?php echo $category_id; ?>">

        <label>Category ID:</label>
        <input type="text" name="category_id_display"
               value="<?php echo $category_id; ?>" disabled>
        <!-- keep real category_id in hidden field above -->

        <br>

        <label>Code:</label>
        <input type="text" name="product_code"
               value="<?php echo htmlspecialchars($product_code); ?>">
        <br>

        <label>Name:</label>
        <input type="text" name="product_name"
               value="<?php echo htmlspecialchars($product_name); ?>">
        <br>

        <label>List Price:</label>
        <input type="text" name="list_price"
               value="<?php echo htmlspecialchars($list_price); ?>">
        <br>

        <input type="submit" value="Update Product">
    </form>

    <p><a href=".?category_id=<?php echo $category_id;
